//  Letter Opener -- version 0.1 alpha release
//
//  (c) 1998 Quine and the +HCU
//
//  Feel free to play with this all you want.  I would
//  love to hear about any changes you make.  I can
//  be reached at wvo_quine@hotmail.com.  What you cannot
//  do is release this program to the general cracking
//  community without the source code including this intro.
//  Furthermore, any work done with this program should
//  credit me, the +HCU, and fravia+'s page at http://fravia.org.
//
//  Ok, no one said this program was going to be pretty.  If you
//  are just learning C/C++, this is not a model you should follow.
//  This is a complete hack done just to get something that works
//  to fravia+ before he finds me and kills for me being so late
//  with this.  Needless to say, at least a modicum of error checking
//  is required.  The code could also use some general tidying
//  up.  Furthermore, only version 4.0 of hasp32b.obj for M$ VC++
//  is searched for.  This needs to be changed to include other
//  compilers and further versions.  All that will come later.
//
//  Usage is explained below.  It's up to you to decide which
//  sections are encrypted and to tell the program.  This should
//  not be hard.  I wasn't about to devise an algorithm to figure
//  out which sections were encrypted and which weren't.  Also,
//  please don't include any sections after the program entry
//  point.  All of those are envelope specific.


#define WIN32_LEAN_AND_MEAN
#define NOUSER
#define NOGDI
#include <windows.h>
#include <stdio.h>
#include <winnt.h>
#include <string.h>
#define IMAGE_DWORD(x) *(DWORD*)((DWORD)pMappedFile+hasp32b_start+x)
#define IMAGE_BYTE(x) *(BYTE*)((DWORD)pMappedFile+hasp32b_start+x)
#define MakePtr( cast, ptr, addValue ) (cast)( (DWORD)(ptr) + (DWORD)(addValue))

HANDLE hFile;
HANDLE hFileMap;
LPVOID pMappedFile;


const int SIG_MARKER_LENGTH = 5;
const int NUM_OF_RELOCS = 10;
const int NUM_GPA_CALLS = 3;
const int SIG_MARKER_LOC = 0x3fd;
unsigned char sig1[SIG_MARKER_LENGTH] = {0x10, 0x2d, 0x51, 0xf0, 0x83};
unsigned char sig2[SIG_MARKER_LENGTH] = {0x51, 0x52, 0x56, 0x57, 0x55};
unsigned char key[0x1000];
unsigned char hasp32b_sig[0x1000];
DWORD hasp32b_call[NUM_GPA_CALLS] = { 0xfc9, 0xfe0, 0xff7 };
DWORD hasp32b_reloc[NUM_OF_RELOCS][2] = {
	0x1D6, 0x1e18,
	0xFBD, 0x1e68,
	0xFC3, 0x200a,
	0xFCE, 0x1e79,
	0xFD4, 0x2306,
	0xFDA, 0x200a,
	0xFE5, 0x2316,
	0xFEB, 0x22d0,
	0xFF1, 0x200a,
	0xFFC, 0x22dd
};

PIMAGE_DOS_HEADER pDOSHeader;
PIMAGE_NT_HEADERS pPEHeader;
PIMAGE_SECTION_HEADER pSectionArray[20];
WORD wNumOfSections;
DWORD dwNumOfRealSections;

typedef struct {
	int length;
	bool encrypted;
	DWORD offset;
	bool code;
} _section;

_section section[20];

void patch_array(unsigned char* array, DWORD offset, DWORD patch)
{
	array[offset+3] = (BYTE)((patch & 0xff000000) >> 24);
	array[offset+2] = (BYTE)((patch & 0x00ff0000) >> 16);
	array[offset+1] = (BYTE)((patch & 0x0000ff00) >> 8);
	array[offset+0] = (BYTE)((patch & 0x000000ff));
}

int main (int argc, char* argv[]) {
	
	bool bSigFound = false;
	// hasp32b_start is the offset from the beginning of file or memory map
	// to the first byte of the known plaintext
	DWORD hasp32b_start;
	// these next two will be used for error checking
	DWORD SigBytesRead=0;
	DWORD KeyBytesWritten=0;

	if (argc!=3)
	{
		printf ("Usage:\n");
		printf ("%s <envelope protected filename> <encrypted sections>\n", argv[0]);
		printf ("\nThe format for the encrypted sections is a binary bitmap\n");
		printf ("of the encrypted sections.  So, if sections 1, 2, 3, 4, and 7\n");
		printf ("are encrypted, you would enter 100111 and the whole command\n");
		printf ("line would look like this:\n\n");
		printf ("ltropnr w32hinst.exe 1001111\n\n");
		printf ("Warning:  this overwrites the exe, so be sure you've got a backup.\n");
		printf ("You must also have haspsig1.dat in the working directory.\n");
		return 1;
	}

	// open the target and map it
	hFile = CreateFile ( (LPCTSTR) argv[1], GENERIC_READ | GENERIC_WRITE,
		FILE_SHARE_READ, NULL, OPEN_EXISTING, NULL, NULL);
	hFileMap = CreateFileMapping ( hFile, NULL, PAGE_READWRITE, 0, 0,
		NULL);
	pMappedFile = MapViewOfFile ( hFileMap, FILE_MAP_WRITE, 0, 0, 0);
	
	// parse the PE header
	pDOSHeader = (PIMAGE_DOS_HEADER) ( pMappedFile);
	pPEHeader = MakePtr(PIMAGE_NT_HEADERS, pDOSHeader, pDOSHeader->e_lfanew);
	pSectionArray[0] = IMAGE_FIRST_SECTION (pPEHeader);
	wNumOfSections = pPEHeader->FileHeader.NumberOfSections;

	// build pSectionArray, which just points into the image map
	for (DWORD i=1; i<wNumOfSections; i++)
		pSectionArray[i] = pSectionArray[0]+i;

	// now build the section array that we'll use in the program
	for (i=0; i<wNumOfSections; i++)
	{
		// if the section starts at the program entry point, we've reached
		// the end of the real sections
		if (pPEHeader->OptionalHeader.AddressOfEntryPoint == pSectionArray[i]->VirtualAddress)
		{
			dwNumOfRealSections = i;
			break;
		}
		// get the smallest section length
		section[i].length = (pSectionArray[i]->SizeOfRawData > pSectionArray[i]->Misc.VirtualSize ? 
			pSectionArray[i]->Misc.VirtualSize : pSectionArray[i]->SizeOfRawData);
		// is it a code section?
		section[i].code = (bool) ((pSectionArray[i]->Characteristics & IMAGE_SCN_CNT_CODE) != 0);
		// get the offset into the file image
		section[i].offset = pSectionArray[i]->PointerToRawData;
		// is it encrypted?
		if ( (i<strlen(argv[2])) && ( *(argv[2]+(strlen(argv[2])-i-1)) == '1'))
			section[i].encrypted = true;
		else
			section[i].encrypted = false;

	}

	// Searches for the hasp32b.obj signature
	printf("Searching for signature ...\n");
	for (DWORD h=0; h<dwNumOfRealSections; h++)
	{
		if (section[h].code)	// only search code sections
		{
			for (i=section[h].offset; (i<(section[h].offset+section[h].length-0x1000)) && (!bSigFound); i++)
			{
				for (int j = 0; (j<SIG_MARKER_LENGTH); j++)
				{
					if (((*(BYTE*)((DWORD)pMappedFile+i+j)^sig1[j])^*(BYTE*)((DWORD)pMappedFile+i+j+0x1000)) != sig2[j])
						// no match at this position, so move on to next byte
						break;
					else
						if (j+1 == SIG_MARKER_LENGTH)
						{
							//all bytes of the signature have matched, so we've found it
							bSigFound = true;
							// Calculate offset in image for beginning of hasp32b.obj
							hasp32b_start = i - SIG_MARKER_LOC;
						}
				}
			}
		}
	}

	
	if (!bSigFound)
	{
		printf("Signature not found.  Sorry.");
		// Sorry also for no resource clean up
		return 1;
	}
	
	printf("Signature found at image offset 0x%x.\n", hasp32b_start);
	
	// we need to calculate this to make sure that the key lines up with
	// the beginning of each section
	DWORD key_align = (hasp32b_start-0x400)%0x1000;
	
	// Read the hasp32b signature into memory
	HANDLE hSigFile = CreateFile("haspsig1.dat", GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, NULL, NULL);
	ReadFile(hSigFile, (LPVOID)hasp32b_sig, 0x1000, &SigBytesRead, NULL);
	CloseHandle(hSigFile);
	
	// Patch the signature array to account for the relocations
	DWORD data_delta = (( IMAGE_DWORD(0x2) ^ *(DWORD*)(hasp32b_sig+2)) ^ IMAGE_DWORD(0x1002))-0x22e1;
	for (i=0; i<NUM_OF_RELOCS; i++)
		patch_array((BYTE*)hasp32b_sig, hasp32b_reloc[i][0], hasp32b_reloc[i][1]+data_delta);
	
	// patch the calls to GetProcAddress
	DWORD gpa_rva = hasp32b_start+0x100e+((IMAGE_DWORD(0xe)^*(DWORD*)(hasp32b_sig+0xe)) ^ IMAGE_DWORD(0x100e));
	for (i=0; i<NUM_GPA_CALLS; i++)
		patch_array((BYTE*)hasp32b_sig, hasp32b_call[i], gpa_rva - (hasp32b_start+hasp32b_call[i]));
	
	// Now we need to generate the key
	printf("Generating key ...\n");
	
	
	// this loop generates the key by xoring the now properly patched
	// known plaintext with the encrypted code
	// the key_align variable serves to line up the key at a 4k boundary
	for (i = 0; i<0x1000; i++)
	{
		key[(i+key_align)%0x1000] = hasp32b_sig[i] ^ IMAGE_BYTE(i);
	}
	
	
	// Save the key -- why?  why not.
	HANDLE hKeyFile=CreateFile("envelope.key", GENERIC_WRITE, 0, 0, CREATE_NEW, 0, 0);
	WriteFile(hKeyFile, (LPVOID)key, 0x1000, &KeyBytesWritten, 0);
	CloseHandle(hKeyFile);
	
	// The key is complete.  Now all we need to do is decrypt the file
	printf("Decrypting file ...\n");
	
	// this loop does the actual decryption by looping through each encrypted
	// section and xoring the encrypted data with the key
	// the section length has the low 3 bits stripped off it because that's
	// what hasp does
	for (i=0; i<dwNumOfRealSections; i++)
	{
		if (section[i].encrypted)
		{
			for (int j=0; j<section[i].length-(section[i].length%0x8); j++)
			{
				*(BYTE*)((DWORD)pMappedFile+section[i].offset+j) ^= key[j%0x1000];
			}
		}
	}
			
	printf("Writing decrypted file to disk ...\n");
	UnmapViewOfFile ( pMappedFile);
	CloseHandle ( hFileMap );
	CloseHandle ( hFile );
	printf("All done.  Say, \"Thank you, Quine.\".\n");
	return 0;
			
}

